print("LEVEL!!!!")
if not location.generate_source and location.generate_target then
  error("location.generate_source and location.generate_target need to be set.")
end
local function create_line(left_pos, ct, idx)
  for i = 0, ct - 1 do
    local pos = left_pos + Vector.new(i, 0)
    game:place(pos, Basic.new(idx))
    if i > 0 then
      game:join(CellFace.new(pos, LEFT))
    end
  end
end
local input_key_pos = 0;
local output_key_pos = 0;
local output_original_pos = 0;
local spec_list = {3, 5, 4, 1, 2};
local function get_spec(n)
  return spec_list[(n % #spec_list) + 1]
end
local can_generate = false
local function make_next_input()
  destroy_rectangle(location.generate_source)
  local l = get_spec(input_key_pos);
  create_line(location.generate_target.greater - Vector.new(l - 1, 0), l, 2)
  create_line(location.generate_source.greater - Vector.new(l - 1, 0), l, 2)
  input_key_pos = input_key_pos + 1
end
local function make_next_copy()
  destroy_rectangle(location.copy_source)
  local l = get_spec(output_key_pos);
  create_line(location.copy_source.greater - Vector.new(l - 1, 0), l, 1)
  output_key_pos = output_key_pos + 1
end
local function make_next_original()
  destroy_rectangle(location.original_source)
  local l = get_spec(output_original_pos);
  create_line(location.original_source.greater - Vector.new(l - 1, 0), l, 2)
  output_original_pos = output_original_pos + 1
end

game:each_step(function()
  if rectangle_empty(location.generate_target) then
    if can_generate then
      make_next_input()
      can_generate = false
    else
      can_generate = true
    end
  end
end)

destroy_rectangle(location.generate_target)
destroy_rectangle(location.copy_source)
destroy_rectangle(location.original_source)
make_next_input()
make_next_copy()
make_next_original()

local original_transit = 0
local copy_transit = 0
local function trailing_part_of_rectangle(r, n)
  return Rectangle.new(r.greater - Vector.new(n - 1, 0), r.greater)
end
local function setup_checker(v, on_accept)
  local open_time = 0
  v.spec = {condition_override = function()
    if open_time > 0 then
      open_time = open_time - 1
      return "open"
    end
    local offset = v.check.greater - v.mirror_source.greater
    local x = get_simple_connected_component(nil, v.mirror_source.greater).found; --can't fail
    local y = get_simple_connected_component(nil, v.check.greater);
    if y.flag == "ok" and grid_offset_cmp(x, y.found, offset) then
      local ct = 0;
      for vec, _ in grid_pairs(x) do
        local b1 = game:at(vec)
        local b2 = game:at(vec + offset)
        assert(b1 and b2)
        if not compare_blocks(b1, b2) then
          return "reject"
        end
        ct = ct + 1
      end
      open_time = ct - 1
      return "accept"
    end
    return "reject";
  end,
  on_accept = on_accept}
end
setup_checker(location.std.checkers[1], make_next_copy)
setup_checker(location.std.checkers[2], make_next_original)
